{ $HDR$}
{**********************************************************************}
{ Unit archived using Team Coherence                                   }
{ Team Coherence is Copyright 2002 by Quality Software Components      }
{                                                                      }
{ For further information / comments, visit our WEB site at            }
{ http://www.TeamCoherence.com                                         }
{**********************************************************************}
{}
{ $Log:  11988: IdStackConsts.pas 
{
{   Rev 1.11    10/28/2003 9:14:54 PM  BGooijen
{ .net
}
{
{   Rev 1.10    10/19/2003 10:46:18 PM  BGooijen
{ Added more consts
}
{
{   Rev 1.9    10/19/2003 9:15:28 PM  BGooijen
{ added some SocketOptionName consts for dotnet
}
{
{   Rev 1.8    10/19/2003 5:21:30 PM  BGooijen
{ SetSocketOption
}
{
{   Rev 1.7    10/2/2003 7:31:18 PM  BGooijen
{ .net
}
{
{   Rev 1.6    2003.10.02 10:16:32 AM  czhower
{ .Net
}
{
{   Rev 1.5    2003.10.01 5:05:18 PM  czhower
{ .Net
}
{
{   Rev 1.4    2003.10.01 1:12:40 AM  czhower
{ .Net
}
{
{   Rev 1.3    2003.09.30 12:09:38 PM  czhower
{ DotNet changes.
}
{
{   Rev 1.2    9/29/2003 10:28:30 PM  BGooijen
{ Added constants for DotNet
}
{
{   Rev 1.1    12-14-2002 14:58:34  BGooijen
{ Added definition for Id_SOCK_RDM and Id_SOCK_SEQPACKET
}
{
{   Rev 1.0    11/13/2002 08:59:14 AM  JPMugaas
}
unit IdStackConsts;

{$I IdCompilerDefines.inc}

interface

{This should be the only unit except OS Stack units that reference
Winsock or lnxsock}
uses
 {$IFDEF LINUX}
  Libc;
 {$ENDIF}
 {$IFDEF MSWINDOWS}
  IdWinsock2;
 {$ENDIF}
 {$IFDEF DOTNET}
  System.Net.Sockets;
 {$ENDIF}

type
  TIdStackSocketHandle = {$IFDEF DOTNET} Socket; {$ELSE} TSocket; {$ENDIF}

var
  Id_SO_True: Integer = 1;
  Id_SO_False: Integer = 0;

const
  {$IFDEF LINUX}
    Id_IP_MULTICAST_TTL = IP_MULTICAST_TTL;                                     
    Id_IP_MULTICAST_LOOP = IP_MULTICAST_LOOP;                                     
    Id_IP_ADD_MEMBERSHIP = IP_ADD_MEMBERSHIP;                                     
    Id_IP_DROP_MEMBERSHIP = IP_DROP_MEMBERSHIP;                                     
  {$ELSE}
    Id_IP_MULTICAST_TTL = 10;                                                            
    Id_IP_MULTICAST_LOOP = 11;                                                            
    Id_IP_ADD_MEMBERSHIP = 12;                                                            
    Id_IP_DROP_MEMBERSHIP = 13;                                                            
  {$ENDIF}
  

(*
  There seems to be an error in the correct values of multicast values in IdWinsock
  The values should be:

  ip_options          = 1;  //* set/get IP options */
  ip_hdrincl          = 2;  //* header is included with data */
  ip_tos              = 3;  //* IP type of service and preced*/
  ip_ttl              = 4;  //* IP time to live */
  ip_multicast_if     = 9;  //* set/get IP multicast i/f  */
  ip_multicast_ttl    = 10; //* set/get IP multicast ttl */
  ip_multicast_loop   = 11; //*set/get IP multicast loopback */
  ip_add_membership   = 12; //* add an IP group membership */
  ip_drop_membership  = 13; //* drop an IP group membership */
  ip_dontfragment     = 14; //* don't fragment IP datagrams */    {Do not Localize}
*)
  {$IFDEF LINUX}
  TCP_NODELAY = 1;
  {$ENDIF}

  // Protocol Family

  {$ifndef DOTNET}
  Id_PF_INET4 = PF_INET;
  Id_PF_INET6 = PF_INET6;
  {$else}
  Id_PF_INET4 = ProtocolFamily.InterNetwork;
  Id_PF_INET6 = ProtocolFamily.InterNetworkV6;
  {$endif}

  // Socket Type
type
  TIdSocketType = {$IFDEF DotNet} SocketType; {$ELSE} Integer; {$ENDIF}
const
  {$IFNDEF DOTNET}
  Id_SOCK_STREAM     = SOCK_STREAM;      //1               /* stream socket */
  Id_SOCK_DGRAM      = SOCK_DGRAM;       //2               /* datagram socket */
  Id_SOCK_RAW        = SOCK_RAW;         //3               /* raw-protocol interface */
  Id_SOCK_RDM        = SOCK_RDM;         //4               /* reliably-delivered message */
  Id_SOCK_SEQPACKET  = SOCK_SEQPACKET;   //5               /* sequenced packet stream */
  {$ELSE}
  Id_SOCK_STREAM     = SocketType.Stream;         // /* stream socket */
  Id_SOCK_DGRAM      = SocketType.Dgram;          // /* datagram socket */
  Id_SOCK_RAW        = SocketType.Raw;            // /* raw-protocol interface */
  Id_SOCK_RDM        = SocketType.Rdm;            // /* reliably-delivered message */
  Id_SOCK_SEQPACKET  = SocketType.Seqpacket;      // /* sequenced packet stream */
  {$ENDIF}

  // IP Protocol type
type
  TIdSocketProtocol     = {$IFDEF DotNet} ProtocolType; {$ELSE} Integer; {$ENDIF}
  TIdSocketOption       = {$IFDEF DotNet} SocketOptionName; {$ELSE} Integer; {$ENDIF}
  TIdSocketOptionLevel  = {$IFDEF DotNet} SocketOptionLevel; {$ELSE} Integer; {$ENDIF}
  
const
  {$ifndef DOTNET}
  Id_IPPROTO_IP = IPPROTO_IP;
  Id_IPPROTO_ICMP = IPPROTO_ICMP;
  Id_IPPROTO_IGMP = IPPROTO_IGMP;
  Id_IPPROTO_TCP = IPPROTO_TCP;
  Id_IPPROTO_UDP = IPPROTO_UDP;
  Id_IPPROTO_RAW = IPPROTO_RAW;
  Id_IPPROTO_MAX = IPPROTO_MAX;
  {$else}
  Id_IPPROTO_IP = ProtocolType.IP;
  Id_IPPROTO_ICMP = ProtocolType.Icmp;
  Id_IPPROTO_IGMP = ProtocolType.Igmp;
  Id_IPPROTO_TCP = ProtocolType.Tcp;
  Id_IPPROTO_UDP = ProtocolType.Udp;
  Id_IPPROTO_RAW = ProtocolType.Raw;
//  Id_IPPROTO_MAX = ProtocolType.; ?????????????????????
  {$endif}

  // Socket Option level
  {$ifndef DOTNET}
  Id_SOL_SOCKET = SOL_SOCKET;
  Id_SOL_IP  = IPPROTO_IP;
  {$else}
  Id_SOL_SOCKET = SocketOptionLevel.Socket;
  Id_SOL_IP = SocketOptionLevel.Ip;
  {$endif}

  // Socket options
  {$ifndef DOTNET}
  Id_SO_BROADCAST        =  SO_BROADCAST;
  Id_SO_DEBUG            =  SO_DEBUG;
  Id_SO_DONTROUTE        =  SO_DONTROUTE;
  Id_SO_KEEPALIVE        =  SO_KEEPALIVE;
  Id_SO_LINGER	         =  SO_LINGER;
  Id_SO_OOBINLINE        =  SO_OOBINLINE;
  Id_SO_RCVBUF           =  SO_RCVBUF;
  Id_SO_REUSEADDR        =  SO_REUSEADDR;
  Id_SO_SNDBUF           =  SO_SNDBUF;
  {$else}
{
SocketOptionName.AcceptConnection;// Socket is listening.
SocketOptionName.AddMembership;//  Add an IP group membership.
SocketOptionName.AddSourceMembership;//  Join a source group.
SocketOptionName.BlockSource;//  Block data from a source.
}
  Id_SO_BROADCAST        =  SocketOptionName.Broadcast;//  Permit sending broadcast messages on the socket.
{
SocketOptionName.BsdUrgent;//  Use urgent data as defined in RFC-1222. This option can be set only once, and once set, cannot be turned off.
SocketOptionName.ChecksumCoverage;//  Set or get UDP checksum coverage.
SocketOptionName.Debug;//  Record debugging information.
SocketOptionName.DontFragment;//  Do not fragment IP datagrams.
SocketOptionName.DontLinger;//  Close socket gracefully without lingering.
SocketOptionName.DontRoute;//  Do not route; send directly to interface addresses.
SocketOptionName.DropMembership;//  Drop an IP group membership.
SocketOptionName.DropSourceMembership;//  Drop a source group.
SocketOptionName.Error;//  Get error status and clear.
SocketOptionName.ExclusiveAddressUse;//  Enables a socket to be bound for exclusive access.
SocketOptionName.Expedited;//  Use expedited data as defined in RFC-1222. This option can be set only once, and once set, cannot be turned off.
SocketOptionName.HeaderIncluded;//  Indicates application is providing the IP header for outgoing datagrams.
SocketOptionName.IPOptions;//  Specifies IP options to be inserted into outgoing datagrams.
SocketOptionName.KeepAlive;//  Send keep-alives.
SocketOptionName.Linger;//  Linger on close if unsent data is present.
SocketOptionName.MaxConnections;//  Maximum queue length that can be specified by Listen.
SocketOptionName.MulticastInterface;//  Set the interface for outgoing multicast packets.
SocketOptionName.MulticastLoopback;//  IP multicast loopback.
SocketOptionName.MulticastTimeToLive;//  IP multicast time to live.
SocketOptionName.NoChecksum;//  Send UDP datagrams with checksum set to zero.
SocketOptionName.NoDelay;//  Disables the Nagle algorithm for send coalescing.
SocketOptionName.OutOfBandInline;//  Receives out-of-band data in the normal data stream.
SocketOptionName.PacketInformation;//  Return information about received packets.
SocketOptionName.ReceiveBuffer;//  Send low water mark.
SocketOptionName.ReceiveLowWater;//  Receive low water mark.
SocketOptionName.ReceiveTimeout;//  Receive time out. This option applies only to synchronous methods; it has no effect on asynchronous methods such as BeginSend.
}
  Id_SO_REUSEADDR        =  SocketOptionName.ReuseAddress;//  Allows the socket to be bound to an address that is already in use.
{
SocketOptionName.SendBuffer;//  Specifies the total per-socket buffer space reserved for sends. This is unrelated to the maximum message size or the size of a TCP window.
SocketOptionName.SendLowWater;//  Specifies the total per-socket buffer space reserved for receives. This is unrelated to the maximum message size or the size of a TCP window.
SocketOptionName.SendTimeout;//  Send timeout. This option applies only to synchronous methods; it has no effect on asynchronous methods such as BeginSend.
SocketOptionName.Type;//  Get socket type.
SocketOptionName.TypeOfService;//  Change the IP header type of service field.
SocketOptionName.UnblockSource;//  Unblock a previously blocked source.
SocketOptionName.UseLoopback;//  Bypass hardware when possible.
}
  {$endif}

  // Additional socket options
  {$ifndef DOTNET}
  Id_SO_RCVTIMEO         = SO_RCVTIMEO;
  Id_SO_SNDTIMEO         = SO_SNDTIMEO;
  {$else}
  {$endif}

  {$ifndef DOTNET}
  Id_IP_TTL              = IP_TTL;
  {$else}
  Id_IP_TTL              = SocketOptionName.IpTimeToLive; //  Set the IP header time-to-live field.
  {$endif}

  //
  {$ifndef DOTNET}
  Id_INADDR_ANY = INADDR_ANY;
  Id_INADDR_NONE = INADDR_NONE;
  {$else}
  {$endif}

  // TCP Options
  {$ifndef DOTNET}
  Id_TCP_NODELAY = TCP_NODELAY;
  Id_INVALID_SOCKET = INVALID_SOCKET;
  Id_SOCKET_ERROR = SOCKET_ERROR;
  
  Id_SOCKETOPTIONLEVEL_TCP = Id_IPPROTO_TCP; // BGO: rename to Id_SOL_TCP
  {$else}
  Id_TCP_NODELAY = SocketOptionName.NoDelay;
  Id_INVALID_SOCKET = nil;
  Id_SOCKETOPTIONLEVEL_TCP = SocketOptionLevel.TCP; // BGO: rename to Id_SOL_TCP
  {$endif}
  //
  {$IFDEF LINUX}
  // Shutdown Options
  Id_SD_Recv = SHUT_RD;
  Id_SD_Send = SHUT_WR;
  Id_SD_Both = SHUT_RDWR;
  //
  Id_WSAEINTR = EINTR;
  Id_WSAEBADF = EBADF;
  Id_WSAEACCES = EACCES;
  Id_WSAEFAULT = EFAULT;
  Id_WSAEINVAL = EINVAL;
  Id_WSAEMFILE = EMFILE;
  Id_WSAEWOULDBLOCK = EWOULDBLOCK;
  Id_WSAEINPROGRESS = EINPROGRESS;
  Id_WSAEALREADY = EALREADY;
  Id_WSAENOTSOCK = ENOTSOCK;
  Id_WSAEDESTADDRREQ = EDESTADDRREQ;
  Id_WSAEMSGSIZE = EMSGSIZE;
  Id_WSAEPROTOTYPE = EPROTOTYPE;
  Id_WSAENOPROTOOPT = ENOPROTOOPT;
  Id_WSAEPROTONOSUPPORT = EPROTONOSUPPORT;
  Id_WSAESOCKTNOSUPPORT = ESOCKTNOSUPPORT;

  Id_WSAEOPNOTSUPP = EOPNOTSUPP;
  Id_WSAEPFNOSUPPORT = EPFNOSUPPORT;
  Id_WSAEAFNOSUPPORT = EAFNOSUPPORT;
  Id_WSAEADDRINUSE = EADDRINUSE;
  Id_WSAEADDRNOTAVAIL = EADDRNOTAVAIL;
  Id_WSAENETDOWN = ENETDOWN;
  Id_WSAENETUNREACH = ENETUNREACH;
  Id_WSAENETRESET = ENETRESET;
  Id_WSAECONNABORTED = ECONNABORTED;
  Id_WSAECONNRESET = ECONNRESET;
  Id_WSAENOBUFS = ENOBUFS;
  Id_WSAEISCONN = EISCONN;
  Id_WSAENOTCONN = ENOTCONN;
  Id_WSAESHUTDOWN = ESHUTDOWN;
  Id_WSAETOOMANYREFS = ETOOMANYREFS;
  Id_WSAETIMEDOUT = ETIMEDOUT;
  Id_WSAECONNREFUSED = ECONNREFUSED;
  Id_WSAELOOP = ELOOP;
  Id_WSAENAMETOOLONG = ENAMETOOLONG;
  Id_WSAEHOSTDOWN = EHOSTDOWN;
  Id_WSAEHOSTUNREACH = EHOSTUNREACH;
  Id_WSAENOTEMPTY = ENOTEMPTY;
  {$endif}
  {$ifdef MSWINDOWS}
  // Shutdown Options
  Id_SD_Recv = 0;
  Id_SD_Send = 1;
  Id_SD_Both = 2;
  //
  Id_WSAEINTR = WSAEINTR;
  Id_WSAEBADF = WSAEBADF;
  Id_WSAEACCES = WSAEACCES;
  Id_WSAEFAULT = WSAEFAULT;
  Id_WSAEINVAL = WSAEINVAL;
  Id_WSAEMFILE = WSAEMFILE;
  Id_WSAEWOULDBLOCK = WSAEWOULDBLOCK;
  Id_WSAEINPROGRESS = WSAEINPROGRESS;
  Id_WSAEALREADY = WSAEALREADY;
  Id_WSAENOTSOCK = WSAENOTSOCK;
  Id_WSAEDESTADDRREQ = WSAEDESTADDRREQ;
  Id_WSAEMSGSIZE = WSAEMSGSIZE;
  Id_WSAEPROTOTYPE = WSAEPROTOTYPE;
  Id_WSAENOPROTOOPT = WSAENOPROTOOPT;
  Id_WSAEPROTONOSUPPORT = WSAEPROTONOSUPPORT;
  Id_WSAESOCKTNOSUPPORT = WSAESOCKTNOSUPPORT;

  Id_WSAEOPNOTSUPP = WSAEOPNOTSUPP;
  Id_WSAEPFNOSUPPORT = WSAEPFNOSUPPORT;
  Id_WSAEAFNOSUPPORT = WSAEAFNOSUPPORT;
  Id_WSAEADDRINUSE = WSAEADDRINUSE;
  Id_WSAEADDRNOTAVAIL = WSAEADDRNOTAVAIL;
  Id_WSAENETDOWN = WSAENETDOWN;
  Id_WSAENETUNREACH = WSAENETUNREACH;
  Id_WSAENETRESET = WSAENETRESET;
  Id_WSAECONNABORTED = WSAECONNABORTED;
  Id_WSAECONNRESET = WSAECONNRESET;
  Id_WSAENOBUFS = WSAENOBUFS;
  Id_WSAEISCONN = WSAEISCONN;
  Id_WSAENOTCONN = WSAENOTCONN;
  Id_WSAESHUTDOWN = WSAESHUTDOWN;
  Id_WSAETOOMANYREFS = WSAETOOMANYREFS;
  Id_WSAETIMEDOUT = WSAETIMEDOUT;
  Id_WSAECONNREFUSED = WSAECONNREFUSED;
  Id_WSAELOOP = WSAELOOP;
  Id_WSAENAMETOOLONG = WSAENAMETOOLONG;
  Id_WSAEHOSTDOWN = WSAEHOSTDOWN;
  Id_WSAEHOSTUNREACH = WSAEHOSTUNREACH;
  Id_WSAENOTEMPTY = WSAENOTEMPTY;
  {$ENDIF}
  {$ifdef DOTNET}
  Id_WSAEBADF    = 10009;
  Id_WSAENOTSOCK = 10038;
  Id_SD_Recv = SocketShutdown.Receive;
  Id_SD_Send = SocketShutdown.Send;
  Id_SD_Both = SocketShutdown.Both;
  {$endif}
                       
implementation

end.
